<?php
/*
Plugin Name: AskApache Search Engine Verify
Plugin URI: http://www.askapache.com/seo/wp-plugin-search-engine-verify.html
Description: Adds the verification meta tags to home page provided by Google and Yahoo <a href="options-general.php?page=aa-searchengine-verify.php">Options configuration panel</a>
Version: 2.4
Author: AskApache
Author URI: http://www.askapache.com
*/


/*
== Installation ==

1. Upload aa-searchengine-verify.zip to the /wp-content/plugins/ directory
2. Unzip into its own folder /wp-content/plugins/aa-searchengine-verify/aa-searchengine-verify.php
3. Activate the plugin through the 'Plugins' menu in WordPress by clicking "AskApache Search Engine Verify"
4. Go to your Options Panel and open the "AskApache Search Engine Verify" submenu. /wp-admin/options-general.php?page=aa-searchengine-verify.php
5. Enter in the meta verification tags and hit the "Update Values" Button.
6. Optionally hit the "Verify Home Page" to view home page’s meta tags
*/



/*
/--------------------------------------------------------------------\
|                                                                    |
| License: GPL                                                       |
|                                                                    |
| AskApache Search Engine Verify Plugin - Adds Verification Meta     |
| Copyright (C) 2007, AskApache, www.askapache.com                   |
| All rights reserved.                                               |
|                                                                    |
| This program is free software; you can redistribute it and/or      |
| modify it under the terms of the GNU General Public License        |
| as published by the Free Software Foundation; either version 2     |
| of the License, or (at your option) any later version.             |
|                                                                    |
| This program is distributed in the hope that it will be useful,    |
| but WITHOUT ANY WARRANTY; without even the implied warranty of     |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      |
| GNU General Public License for more details.                       |
|                                                                    |
| You should have received a copy of the GNU General Public License  |
| along with this program; if not, write to the                      |
| Free Software Foundation, Inc.                                     |
| 51 Franklin Street, Fifth Floor                                    |
| Boston, MA  02110-1301, USA                                        |   
|                                                                    |
\--------------------------------------------------------------------/
*/

function aa_sev_options_setup() {
    add_options_page('AskApache Search Engine Verify', 'AA SearchEngineVerify', 5, basename(__FILE__), 'aa_sev_page');
}
add_action('admin_menu', 'aa_sev_options_setup');


function askapache_sev(){
	if(is_home() && !is_paged()){
	$sevgoogle = get_option('aa_sev_google');
	$sevyahoo = get_option('aa_sev_yahoo');
	echo "\n".'	'.$sevgoogle."\n";
	echo '	'.$sevyahoo."\n";
	}
}



//---------------------------
function aa_sev_page() {
	global $wpdb;
	
	
	$aa_status='';
	$mes='';
	$tags=array();
	$AA_SEV_VERSION = get_option('aa_sev_version');
	$siteurl=get_option('siteurl');
	$sevgoogle = get_option('aa_sev_google');
	$sevyahoo = get_option('aa_sev_yahoo');


    // security
    if ( function_exists('current_user_can') && !current_user_can('manage_options') ) die(__('Cheatin&#8217; uh?'));
    if (! user_can_access_admin_page())  wp_die( __('You do not have sufficient permissions to access this page.') );
	
	// get values

	if($_SERVER['REQUEST_METHOD']==='POST'){
        $valid_nonce = wp_verify_nonce($_REQUEST['_wpnonce'], 'askapache-sev-update_modify');
		if(!$valid_nonce)die('not valid!');
		
		if(isset($_POST['sevgoogle']))	update_option('aa_sev_google',stripslashes($_POST['sevgoogle']));
		if(isset($_POST['sevyahoo']))	update_option('aa_sev_yahoo',stripslashes($_POST['sevyahoo']));
		$sevgoogle = get_option('aa_sev_google');
		$sevyahoo = get_option('aa_sev_yahoo');
		
		$tags=get_meta_tags($siteurl);			
		ob_start();
		echo '<div id="message" class="updated fade">';
		echo '<p>Great!  Now check the source code of your home page for them.  You may need to clear your cache first.</p></div>';
		$aa_status.=ob_get_clean();
	} 

	
	



    $aa_head='<p style="text-align:center;">[ <a href="http://www.askapache.com/seo/wp-plugin-search-engine-verify.html">AskApache Search Engine Verify Plugin <strong>'. 
	$AA_SEV_VERSION . '</strong></a> - <a href="http://www.askapache.com/">Author Home</a> ]</p>
	<hr style="visibility:hidden;">';
	
	$aa_main ='<div class="wrap">
    <h2>AskApache Search Engine Verify ' . 	$AA_SEV_VERSION . '</h2>
	<form action="' . $_SERVER['REQUEST_URI'] . '" id="sform" class="globe2" method="post">';
	
	
	$aa_foot='<fieldset class="options">
        <legend>Set verification strings</legend>
        <ul style="list-style:none;list-style-type:none;">
        <li><label for="sevgoogle">Google: <input size="90" type="text" class="code" name="sevgoogle" id="sevgoogle" value="'.htmlentities($sevgoogle).'" /></label></li>
        <li><label for="sevyahoo">&nbsp;Yahoo: <input size="90" type="text" class="code" name="sevyahoo" id="sevyahoo" value="'.htmlentities($sevyahoo).'" /></label></li>
        <li class="BT" style="padding-left:4em;"><input type="submit" name="update" id="update" class="button" value="Add Site Authorization Meta Tags" /></li>
		</ul></fieldset></form></div>
		
		<div class="wrap">
		<p style="text-align:center;">&laquo;&laquo; <a href="https://siteexplorer.search.yahoo.com/mysites">Get Yahoo Code</a> - <a href="https://www.google.com/webmasters/tools/siteoverview">Get Google Code</a> &raquo;&raquo;</p>
		<hr style="visibility:hidden;" />
		<p style="text-align:center;"><a href="http://www.askapache.com/seo/404-google-wordpress-plugin.html">Best 404 Error Page with Google SEO - WordPress Plugin for 404.php</a></p>
		</div>';



	_e($aa_head);
	_e($aa_status);
	_e($aa_main);
	if ( function_exists('wp_nonce_field') ) wp_nonce_field('askapache-sev-update_modify');
	_e($aa_foot);
}




add_action('wp_head', 'askapache_sev');


function askapache_sev_deactivate(){
	delete_option('aa_sev_version');
    delete_option('aa_sev_google');
    delete_option('aa_sev_yahoo'); 
}

function askapache_sev_activate(){
	update_option('aa_sev_version','2.4');
	update_option('aa_sev_google','<meta name="verify-v1" content="00y24rDZT26L9jNa53+9abYafa07A4MCSB8f2MIfAVk=" />');
	update_option('aa_sev_yahoo','<meta name="y_key" content="b5d1fb5436bfa5f7" />');
}
register_deactivation_hook(__FILE__, 'askapache_sev_deactivate');
register_activation_hook(__FILE__, 'askapache_sev_activate');
?>